#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__ = "chenwei"
# Date: 2018/11/15

from utils.base import APIView
from utils.time_utils import analysis_time
from utils.logger import error_logger


class PushListView(APIView):
    def get(self, request):
        page = int(request.GET.get('page', 1))
        limit = int(request.GET.get('limit', 10))
        filter = self.handle_filter(request.GET.get('filter', ""))
        try:
            data = self.rpc['venus/sun/push/list'](offset=(page-1) * limit, limit=limit, filters=filter).unwrap()
        except Exception as e:
            error_logger.error(u'获取push列表失败%s', e)
            raise
        return data


class PushUpdateOrCreateView(APIView):
    def get(self, request):
        id = request.GET.get('id')
        try:
            data = self.rpc['venus/sun/push/get'](id=id).unwrap()
        except Exception as e:
            error_logger.error(u'获取%s-push信息失败%s' %(id, e))
            raise
        return {'data': data}

    def post(self, request):
        id = request.POST.get('id', '')
        creator_id = request.POST.get('creator_id')
        push_time = analysis_time(request.POST.get('push_time', 0))
        group_topic_id = request.POST.get('group_topic_id', '')
        icon = request.POST.get('icon', '')
        if icon.endswith('-w'):
            icon = request.POST.get('icon', '')[:-2]

        url = request.POST.get('url', '')
        if url == '推送帖子':
            url = 'alpha://topic_detail?topic_id='
        elif url == '推送小组':
            url = 'alpha://group_detail?group_id='
        full_url = url + group_topic_id

        data = {
            'url': full_url,
            'push_time': push_time,
            'icon': icon,
            'content': request.POST.get('content', ''),
            'title': request.POST.get('title', ''),
            'creator_id': creator_id
        }
        try:
            rep = self.rpc['venus/sun/push/edit'](id=id, data=data).unwrap()
        except Exception as e:
            error_logger.error(u'创建/编辑%s-push信息失败%s' % (id, e))
            raise
        return {
            "message": '更新成功',
            "id": rep['id']
        }


class EffectPushTaskView(APIView):
    def get(self, request):
        push_task_id = request.GET.get('id')
        try:
            self.rpc['venus/sun/push/effect_push_task'](id=push_task_id).unwrap()
        except Exception as e:
            error_logger.error(u'%s-push生效失败%s' % (push_task_id, e))
            raise
        return {
            'message': '操作成功'
        }