#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__ = "chenwei"
# Date: 2018/11/19

from utils.base import APIView
from gm_upload import upload


class FileUpload(APIView):

    args_POST = {
        'img_type': {
            'access': int,
        },
    }

    def post(self, request):
        image_type = self.args_post.get('uploadType')
        image = request.FILES.get('file')
        data = image.read()
        full_image_url = upload(data, img_type=int(image_type)) + '-w'
        return {
            'file_url': full_image_url
        }
