#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__ = "chenwei"
# Date: 2018/11/15

import json
from utils.base import APIView
from utils.logger import error_logger


class CelebrityListView(APIView):
    def get(self, request):
        page = int(request.GET.get('page', 0))
        limit = int(request.GET.get('limit', 10))
        filter = self.handle_filter(request.GET.get('filter', ""))
        try:
            data = self.rpc['venus/sun/celebrity/list'](offset=(page-1)*limit, limit=limit, filters=filter).unwrap()
        except Exception as e:
            error_logger.error(u'获取明星列表失败%s', e)
            raise
        return data

    def post(self, request):
        ids = json.loads(request.POST.get('ids', '[]'))
        updates = json.loads(request.POST.get('update', '{}'))

        try:
            self.rpc['venus/sun/celebrity/batch/update'](updates=updates, ids=ids).unwrap()
        except Exception as e:
            error_logger.error(u'批量更新明星列表失败%s', e)
            raise
        return {
            "message": "更新成功"
        }


class CelebrityUpdateOrCreate(APIView):
    def get(self, request):
        id = request.GET.get('id')
        try:
            data = self.rpc['venus/sun/celebrity/get'](id=id).unwrap()
        except Exception as e:
            error_logger.error(u'获取%d明星信息失败%s' %(id, e))
            raise
        return {'data': data}

    def post(self, request):
        id = request.POST.get('id', '')
        gender = request.POST.get('gender')
        group_ids = list(set(map(lambda x: x.split(":")[0], json.loads(request.POST.get('groups', '[]')))))
        updates = {
            'gender': ''
        }
        if not id:
            updates['gender'] = int(gender)
        else:
            if gender == '男':
                updates['gender'] = 0
            elif gender == '女':
                updates['gender'] = 1

        data = {
            'name': request.POST.get('name'),
            'gender': updates['gender'],
            'city_id': request.POST.get('city').split(":")[0],
            'is_online': int(request.POST.get('is_online')),
            'desc': request.POST.get('description'),
            'portrait': request.POST.get('avatar')[:-2],
            'group_ids': group_ids,
        }
        try:
            self.rpc['venus/sun/celebrity/edit'](id=id, data=data).unwrap()
        except Exception as e:
            error_logger.error(u'创建/编辑%d明星信息失败%s' % (id, e))
            raise

        return {
            'message': '更新成功'
        }


class CelebrityRelatedGroup(APIView):
    def get(self, request):
        id = request.GET.get('id')
        offset = int(request.GET.get('page', 0))
        count = int(request.GET.get('limit', 10))
        filters = {'star_id': id, 'is_online': True}
        try:
            data = self.rpc['venus/sun/group/list'](filters=filters, offset=(offset-1) * count, limit=count).unwrap()
        except Exception as e:
            error_logger.error(u'获取%d明星小组信息失败%s' % (id, e))
            raise
        return data
