import time
from utils.base import APIView
from gm_upload import upload, upload_file
from openpyxl import load_workbook


class VirtualVote(APIView):

    def post(self, request):
        
        xls_file = request.FILES.get('file')
        if not xls_file:
            return u'文件上传出错'

        wb = load_workbook(xls_file)
        data = wb.get_sheet_by_name(wb.get_sheet_names()[0])
        
        row_data = [item.value for row in data.rows for item in row if item.value]
        user_ids = []
        for item in row_data:
            try:
                user_id = int(item)
                user_ids.append(user_id)
            except:
                continue
        if not user_ids:
            return u'上传文件失败'
            
        self.rpc['venus/sun/tools/virtual_vote'](user_ids=user_ids).unwrap()

        return u'Ok'
