#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__ = "chenwei"
# Date: 2018/12/11

import json
from utils.base import APIView

from utils.logger import error_logger


class FaceStarEdit(APIView):

    def get(self, request):

        _id = request.GET.get('id')
        try:
            data = self.rpc['mercury/face/star/get'](_id=_id).unwrap()
        except Exception as e:
            error_logger.error(u'获取 {id} 明星信息失败 {e} '.format(id=_id, e=e))
            raise

        return {'data': data}

    def post(self, request):
        _id = request.POST.get('id')
        name = request.POST.get('name')
        sex = request.POST.get('sex')
        model_type = request.POST.get('model_type')
        ordinary_image_url = request.POST.get('ordinary_image_url')
        modeling_uv_url = request.POST.get('modeling_uv_url')
        modeling_obj_url = request.POST.get('modeling_obj_url')
        try:
            self.rpc['mercury/face/create_star'](
                name=name,
                sex=sex,
                ordinary_image_url=ordinary_image_url,
                modeling_obj_url=modeling_obj_url,
                modeling_uv_url=modeling_uv_url,
                _id=_id,
                model_type=model_type
            ).unwrap()
        except Exception as e:
            raise e

        return {
            'message': '创建成功'
        }


class StarListView(APIView):

    def get(self, request):
        page = int(request.GET.get('page', 1))
        limit = int(request.GET.get('limit', 10))
        filter = self.handle_filter(request.GET.get('filter', ""))
        try:
            data = self.rpc['mercury/face/star/list'](offset=(page-1) * limit, limit=limit, filters=filter).unwrap()
        except Exception as e:
            error_logger.error(u'获取明星列表失败 %s', e)
            raise

        return data

    def post(self, request):
        ids = json.loads(request.POST.get('ids', '[]'))
        updates = json.loads(request.POST.get('updates', '{}'))

        try:
            self.rpc['mercury/face/batch/update'](ids=ids, updates=updates).unwrap()
        except Exception as e:
            error_logger.error(u'批量更新明星列表失败 %s', e)
            raise
        return {
            "message": "更新成功"
        }


class FacePartEdit(APIView):

    def get(self, request):
        _id = request.GET.get('id')
        try:
            data = self.rpc['mercury/face/part/get'](_id=_id).unwrap()
        except Exception as e:
            error_logger.error(u'获取 {id} 局部模型信息失败 {error} '.format(id=_id, error=e))
            raise

        return {'data': data}

    def post(self, request):
        _id = request.POST.get('id')
        name = request.POST.get('name')
        model_id = request.POST.get('model_id')
        ordinary_image_url = request.POST.get('ordinary_image_url')
        part_type = request.POST.get('part_type')
        try:
            self.rpc['mercury/face/part/create'](
                name=name,
                model_id=model_id,
                ordinary_image_url=ordinary_image_url,
                part_type=part_type,
                _id=_id
            ).unwrap()
        except Exception as e:
            raise e

        return {
            'message': '创建成功'
        }


class FacePartListView(APIView):

    def get(self, request):
        page = int(request.GET.get('page', 1))
        limit = int(request.GET.get('limit', 10))
        filter = self.handle_filter(request.GET.get('filter', '{}'))
        try:
            data = self.rpc['mercury/face/part/list'](offset=(page-1) * limit, limit=limit, filters=filter).unwrap()
        except Exception as e:
            error_logger.error(u'获取局部模型列表失败 %s', e)
            raise

        return data

    def post(self, request):
        ids = json.loads(request.POST.get('ids', '[]'))
        updates = json.loads(request.POST.get('updates', '{}'))

        try:
            self.rpc['mercury/face/part/batch/update'](ids=ids, updates=updates).unwrap()
        except Exception as e:
            error_logger.error(u'批量更新局部模型列表失败 %s', e)
            raise
        return {
            "message": "更新成功"
        }


class FacePartTypeListView(APIView):

    def get(self, request):

        page = int(request.GET.get('page', 1))
        limit = int(request.GET.get('limit', 10))
        try:
            data = self.rpc['mercury/face/part/type_list'](offset=(page-1) * limit, limit=limit).unwrap()
        except Exception as e:
            error_logger.error(u'获取局部模型类型列表失败 %s', e)
            raise

        return data
