#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__ = "chenwei"
# Date: 2018/11/15


from django.conf.urls import url

from .pick import *
from .push import *
from .user import *
from .topic import *
from .star import *
from .account import *
from .search import *
from .tag import *
from .upload import *
from .token import *
from .face_star import *
from .advertise import *
from .channel_build import *
from .commons import *
from .pictorial import *
from .operation import *
from .tools import *
from .beauty import *
from .word_parent import *
from .activity import *
from .brand import *
from .product import *
from .category import *
from .classify import *
from .effect import *
from .skin_check import *
from .reply import *


urlpatterns = [
    # 登陆,注销相关
    url(r'^account/login$', LoginView.as_view()),
    url(r'^account/logout$', LogoutView.as_view()),
    url(r'^account/get$', LoginView.as_view()),
    url(r'^account/reset_password', ResetPasswordView.as_view()),

    url(r'^account/list$', AccountList.as_view()),
    url(r'^account/list/update$', AccountList.as_view()),
    url(r'^account/detail$', AccountUpdateOrCreateView.as_view()),
    url(r'^account/create$', AccountUpdateOrCreateView.as_view()),

    # user相关
    url(r'^user/list$', UserListView.as_view()),
    url(r'^user/list/update$', UserListView.as_view()),
    url(r'^user/get$', UserUpdateOrCreate.as_view()),
    url(r'^user/create$', UserUpdateOrCreate.as_view()),
    url(r'^user/images/get$', UserImage.as_view()),
    url(r'^user/images/create$', UserImage.as_view()),

    # topic相关
    url(r'^topic/list$', TopicListView.as_view()),
    url(r'^topic/img/list$', TopicImageListView.as_view()),
    url(r'^topic/detail$', TopicUpdateOrCreateView.as_view()),
    url(r'^topic/create$', TopicUpdateOrCreateView.as_view()),
    url(r'^topic/batch_update$', TopicListBatchUpdate.as_view()),
    url(r'^topic/related_pictorial_info$', TopicRelatePictorialInfo.as_view()),
    url(r'^topic/ballot$', TopicBallot.as_view()),
    url(r'^topic/product/add$', TopicProductAdd.as_view()),
    url(r'^topic/product/del$', TopicProductDel.as_view()),

    # star相关
    url(r'^celebrity/list$', CelebrityListView.as_view()),
    url(r'^celebrity/list/update$', CelebrityListView.as_view()),
    url(r'^celebrity/create$', CelebrityUpdateOrCreate.as_view()),
    url(r'^celebrity/detail$', CelebrityUpdateOrCreate.as_view()),
    url(r'^celebrity/celebrity_related_pictorial_info', CelebrityRelatedPictorial.as_view()),

    # push相关
    url(r'^push/list$', PushListView.as_view()),
    url(r'^push/create', PushUpdateOrCreateView.as_view()),
    url(r'^push/detail', PushUpdateOrCreateView.as_view()),
    url(r'^push/effect_push', EffectPushTaskView.as_view()),

    # pick相关
    url(r'^pick/list$', PickListView.as_view()),
    url(r'^pick/list/update$', PickListView.as_view()),
    url(r'^pick/create$', UpdateOrCreateView.as_view()),
    url(r'^pick/detail/', UpdateOrCreateView.as_view()),
    url(r'^pick/topic/list$', PickTopicView.as_view()),
    url(r'^pick/celebrity/list$', PickCelebrityListView.as_view()),
    url(r'^pick/add_fake_pick_nums$', PickUserListView.as_view()),
    url(r'^pick/topic', PickTopicView.as_view()),
    url(r'^pick/celebrity', PickCelebrityListView.as_view()),
    url(r'^pick/del_celebrity', PickCelebrityListView.as_view()),
    url(r'^pick/del_topic', PickTopicView.as_view()),

    # 标签相关
    url(r'^tag/list$', TagListView.as_view()),
    url(r'^tag/list/update$', TagListView.as_view()),
    url(r'^tag/create$', TagUpdateOrCreateView.as_view()),
    url(r'^tag/detail$', TagUpdateOrCreateView.as_view()),
    url(r'^tag/register_show/update$', TagRegisterUpdateView.as_view()),
    url(r'^tag/filter/list$', TagFilterList.as_view()),
    url(r'^tag/filter/add$', TagFilterCreate.as_view()),
    url(r'^tag/filter/delete$', TagFilterDelete.as_view()),
    url(r'^tag/search_recommend_keyword$', TagSearchRecommendKeyword.as_view()),
    url(r'^tag/search_default_keyword$', SearchDefaultKeyword.as_view()),

    # 标签类型相关
    url(r'^tag/tagtype/list$', TagTypeListView.as_view()),
    url(r'^tag/tagtype/list/update$', TagTypeListView.as_view()),
    url(r'^tag/tagtype/create$', TagTypeUpdateOrCreateView.as_view()),
    url(r'^tag/tagtype/detail$', TagTypeUpdateOrCreateView.as_view()),

    url(r'^tag_set/list$', TagSetListView.as_view()),
    url(r'^tag_set/create$', TagSetUpdateOrCreateView.as_view()),
    url(r'^tag_set/delete$', TagSetDeleteView.as_view()),

    # 扫脸相关
    url(r'^face/star/create$', FaceStarEdit.as_view()),
    url(r'^face/star/list$', StarListView.as_view()),
    url(r'^face/star/list/update$', StarListView.as_view()),
    url(r'^face/star/detail$', FaceStarEdit.as_view()),
    url(r'^face/part/detail$', FacePartEdit.as_view()),
    url(r'^face/part/create$', FacePartEdit.as_view()),
    url(r'^face/part/list$', FacePartListView.as_view()),
    url(r'^face/part/list/update$', FacePartListView.as_view()),
    url(r'^face/part/type_list$', FacePartTypeListView.as_view()),

    # 文案相关
    url(r'^advertise/edit', AdvertiseCreateView.as_view()),
    url(r'^advertise/list$', AdvertiseListView.as_view()),
    url(r'^advertise/create$', AdvertiseCreateView.as_view()),

    # 渠道打包相关API
    url(r'^channel_build/channel/get', ChannelList.as_view()),
    url(r'^channel_build/channel_version/get', ChannelVersionList.as_view()),
    url(r'^channel_build/channel/detail', Channel.as_view()),
    url(r'^channel_build/channel/edit', Channel.as_view()),
    url(r'^channel_build/build', ChannelPacked.as_view()),
    url(r'^channel_build/version/get', VersionList.as_view()),
    url(r'^channel_build/version_channel/get', VersionChannelList.as_view()),
    url(r'^channel_build/version/detail', VersionDetailUpdate.as_view()),
    url(r'^channel_build/version/update', VersionDetailUpdate.as_view()),
    url(r'^channel_build/batch/release', BatchPublishVersion.as_view()),
    url(r'^channel_build/version/create', VersionCreate.as_view()),

    url(r'^suggestion/list$', SuggestionListView.as_view()),

    # 画报相关
    url(r'^pictorial/topic/set_rank$', PictorialTopicSetRank.as_view()),
    url(r'^pictorial/topic/del$', PictorialTopicDel.as_view()),
    url(r'^pictorial/list$', PictorialListView.as_view()),
    url(r'^pictorial/list/update$', PictorialListView.as_view()),
    url(r'^pictorial/get$', PictorialUpdateOrCreate.as_view()),
    url(r'^pictorial/create$', PictorialUpdateOrCreate.as_view()),
    url(r'^pictorial/topics$', PictorialTopics.as_view()),
    url(r'^pictorial/user/list$', PictorialUserList.as_view()),
    url(r'^pictorial/feed/list$', PictorialFeedlListView.as_view()),
    url(r'^pictorial/feed/rank$', PictorialFeedlRank.as_view()),
    url(r'^pictorial/feed/delete$', PictorialFeedDelete.as_view()),
    url(r'^pictorial/topic/list$', PictorialTopicList.as_view()),

    #运营位
    url(r'^topic/home_recommend/list', TopicHomeRecommendList.as_view()),
    url(r'^topic/home_recommend/edit', TopicHomeRecommendEdit.as_view()),
    url(r'^operation/home_fix', TopicHomeFixOperation.as_view()),
    url(r'^operation/pictorial/recommend/list', PictorialHomeRecommendList.as_view()),
    url(r'^operation/pictorial/recommend/update', PictorialHomeRecommendUpdate.as_view()),
    url(r'^operation/edit', OperationEdit.as_view()),
    url(r'^operation/list', OperationList.as_view()),
    url(r'^operation/delete', OperationDelete.as_view()),
    url(r'^operation/search_keyword$', OperationSearchKeyword.as_view()),

    # 工具
    url(r'^tools/virtual_vote$', VirtualVote.as_view()),
    url(r'^tools/batch_update_topic_tag$', BatchUpdateTopicTag.as_view()),
    url(r'^tools/batch_create_topic_with_ai_fashion_tag$', BatchCreateTopicWithAiFashionTag.as_view()),
    url(r'^tools/add_virt_fans', AddVirtFans.as_view()),

    # 母词
    url(r'^word_parent/list$', WordParentListView.as_view()),
    url(r'^word_parent/get$', WordParentInfoView.as_view()),
    url(r'^word_parent/create$', WordParentCreateView.as_view()),
    url(r'^word_parent/update$', WordParentUpdateView.as_view()),
    url(r'^word_parent/delete$', WordParentDeleteView.as_view()),

    # 美图
    url(r'^beauty/list$', BeautyListView.as_view()),
    url(r'^beauty/get$', BeautyInfoView.as_view()),
    url(r'^beauty/create$', BeautyCreateView.as_view()),
    url(r'^beauty/update$', BeautyUpdateView.as_view()),
    url(r'^beauty/delete$', BeautyDeleteView.as_view()),

    # 活动
    url(r'^activity/list$', ActivityListView.as_view()),
    url(r'^activity/get$', ActivityInfoView.as_view()),
    url(r'^activity/create$', ActivityCreateView.as_view()),
    url(r'^activity/update$', ActivityUpdateView.as_view()),
    url(r'^activity/delete$', ActivityDeleteView.as_view()),
    url(r'^activity/pictorial$', PictorialActivityView.as_view()),
    url(r'^activity/pictorial$', PictorialActivityView.as_view()),
    url(r'^activity/pictorial/list$', PictorialActivityListView.as_view()),
    url(r'^activity/pictorial/online$', PictorialActivityOnlineView.as_view()),

    # 品牌
    url(r'^brand/list$', BrandListView.as_view()),
    url(r'^brand/info$', BrandInfoView.as_view()),
    url(r'^brand/create$', BrandCreateView.as_view()),
    url(r'^brand/update$', BrandUpdateView.as_view()),

    # 商品
    url(r'^product/list$', ProductListView.as_view()),
    url(r'^product/create$', ProductCreateView.as_view()),
    url(r'^product/update$', ProductUpdateView.as_view()),
    url(r'^product/info$', ProductInfoView.as_view()),
    url(r'^product/search', ProductSearchView.as_view()),

    # 商品类目
    url(r'^category/list$', CategoryListView.as_view()),

    # 商品分类
    url(r'^classify/list$', ClassifyListView.as_view()),

    # 商品功效
    url(r'^effect/list$', EffectListView.as_view()),

    #评论相关
    url(r'^reply/list$', ReplyUpdateOrCreateView.as_view()),
    url(r'^reply/batch_delete$', ReplyUpdateOrCreateView.as_view()),
    url(r'^reply/create$', ReplyCreate.as_view()),
    url(r'^reply/vote$', ReplyVote.as_view()),

    # 评论管理
    url(r'^reply/manage/edit$', ReplyManageEdit.as_view()),
    url(r'^reply/manage/batch/move$', ReplyManageBatchMove.as_view()),
    url(r'^reply/manage/list$', ReplyManageListView.as_view()),
    url(r'^reply/manage/create$', ReplyCreate.as_view()),
    url(r'^reply/manage/batch/update$', ReplyManageBatchUpdate.as_view()),

    # 测肤
    url(r'^skin_check/pictorial$', SkinCheckPictorial.as_view()),
    url(r'^skin_check/config$', SkinCheckConfig.as_view()),
]

search_urlpatterns = [
    url(r'search/country$', CountrySearchView.as_view()),
    url(r'search/user$', UserSearchView.as_view()),
    url(r'search/tag$', TagSearchView.as_view()),
    url(r'search/celebrity$', CelebritySearchView.as_view()),
    url(r'search/city$', CitySearchView.as_view()),
    url(r'search/topic$', TopicSearchView.as_view()),
    url(r'search/tagtype$', TagTypeSearchView.as_view()),
    url(r'search/pictorial$', PictorialSearchView.as_view()),
    url(r'search/pictorial_activity$', PictorialActivitySearchView.as_view()),
]

common_urlpatterns = [
    url(r"^file/upload$", FileUpload.as_view()),
    url(r"^file/batch/upload$", FileBatchUpload.as_view()),
    url(r"^get_token/$", QiniuToken.as_view()),
]

urlpatterns += search_urlpatterns
urlpatterns += common_urlpatterns
