#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__ = "chenwei"
# Date: 2018/11/15

import json
from django.conf import settings
from gm_types.ascle import ERROR
from gm_upload import IMG_TYPE, upload_with_short

from utils.base import APIView
from django.contrib.auth.hashers import make_password

from utils.download import download_img_func
from utils.logger import error_logger
from utils.pic_tools import tailor_image


class UserListView(APIView):
    def get(self, request):
        pictorial_id = request.GET.get('pictorial_id', '')
        gender = request.GET.get('gender', None)
        page = int(request.GET.get('page', 1))
        limit = int(request.GET.get('limit', 10))
        filters = self.handle_filter(request.GET.get('filter', '{}'))
        if pictorial_id:
            filters.update({'pictorial_id': pictorial_id})
        if gender:
            filters.update({'gender': gender})
        try:
            data = self.rpc['venus/sun/user/list'](offset=(page-1)*limit, limit=limit, filters=filters).unwrap()
        except Exception as e:
            error_logger.error(u'获取用户列表失败%s', e)
            raise
        return data

    def post(self, request):
        ids = json.loads(request.POST.get('ids', '[]'))
        updates = json.loads(request.POST.get('updates', '{}'))
        try:
            self.rpc['venus/sun/user/batch/update'](updates=updates, ids=ids).unwrap()
        except Exception as e:
            error_logger.error(u'批量更新user列表失败%s', e)
            raise
        return {
            "message": "更新成功"
        }


class UserUpdateOrCreate(APIView):
    def get(self, request):
        id = request.GET.get('id')
        try:
            data = self.rpc['venus/sun/user/get'](id=id).unwrap()
        except Exception as e:
            error_logger.error(u'获取%s用户详情失败%s'%(id, e))
            raise
        return data

    def post(self, request):

        id = request.POST.get('id', '')
        user_id = request.POST.get('user_id', '')
        tag_ids = list(map(lambda x: x.split(":")[0], json.loads(request.POST.get('tags', '[]'))))
        password = make_password(settings.PUPPET_PASSWORD, None, 'pbkdf2_sha256')
        body_esthetics_tag_ids = list(
            map(lambda x: x.split(':')[0], json.loads(request.POST.get('body_esthetics_tags', '[]'))))

        data = {
            'user_id': user_id,
            'password': password,
            'is_recommend': int(request.POST.get('is_recommend')) if request.POST.get('is_recommend') else 0,
            'profile_pic': request.POST.get('avatar')[:-2],
            'nick_name': request.POST.get('nick_name'),
            'tag_ids': tag_ids,
            'is_puppet': int(request.POST.get('is_puppet')),
            'city_id': request.POST.get('city', '').split(":")[0],
            'phone': request.POST.get('phone'),
            'email': request.POST.get('email'),
            'gender': request.POST.get('gender'),
            'is_tcc': int(request.POST.get('is_tcc', 0)),
            'body_esthetics_tag_ids': body_esthetics_tag_ids,
            'is_kol': int(request.POST.get('is_kol', 0)),
        }

        try:
            self.rpc['venus/sun/user/edit'](id=id, data=data).unwrap()
        except Exception as e:
            error_logger.error(u'创建/编辑%s用户详情失败%s' % (id, e))
            raise
        return {
            'message': '更新成功'
        }


class PictorialUserList(APIView):
    def get(self, request):
        id_ = request.GET.get('pictorial_id')
        offset = int(request.GET.get('page', 0))
        count = int(request.GET.get('limit', 10))
        filters = {'pictorial_id': id_, 'is_online': True}
        try:
            data = self.rpc['venus/sun/pictorial/user/list'](filters=filters, offset=(offset - 1) * count, count=count).unwrap()
        except Exception as e:
            error_logger.error(u'获取画报用户列表失败%s' , e)
            raise
        return data


class UserImage(APIView):

    def post(self, request):
        image_id = request.POST.get('image_id', '')
        image_url = request.POST.get('image_url', '')
        user_id = request.POST.get('user_id', '')

        if not all([image_id, image_url, user_id]):
            error_logger.error(u'参数不完整')
            return self.write_fail(code=ERROR.ARG_MISS, message='参数不完整')

        resp = self.rpc['venus/sun/user/check_image'](
            user_id=user_id, image_id=image_id).unwrap()
        if resp:
            return self.write_success(data='', message='操作成功')
        # 目前不需要 从图片中切出人脸
        # try:
        #     data = self.rpc['saber/face/detect'](url=image_url).unwrap()
        # except Exception as e:
        #     error_logger.error(u'分析人脸失败：%s', e)
        #     return self.write_fail(code=-1, message='分析人脸失败')

        # faces = [{
        #         "point": [
        #             item["rect"]["left"],
        #             item["rect"]["top"],
        #             item["rect"]["right"]-item["rect"]["left"],
        #             item["rect"]["bottom"]-item["rect"]["top"]]} for item in data.get("faces", [])]
        # if faces:
        #     point = faces[0].get('point', [])
        # else:
        #     return self.write_fail(code=-1, message='获取人脸失败')

        # file_path = download_img_func(image_url, user_id, suffix="png")
        # images = tailor_image(file_path, [point])
        # header_pic_path = images[0]
        # with open(header_pic_path, 'rb') as f:
        #     image_url = upload_with_short(f, img_type=IMG_TYPE.USEREXTRA)[0]
        try:
            result = self.rpc['venus/sun/user/create_update_image'](
                image_url=image_url, user_id=user_id, image_id=image_id).unwrap()
        except Exception as e:
            raise e
        return self.write_fail(
            code=-1 if result else 0,
            message="成功" if result else "失败"
        )

    def get(self, request):
        user_id = request.GET.get('user_id')
        offset = int(request.GET.get('page', 1))
        count = int(request.GET.get('limit', 10))
        if not user_id:
            error_logger.error(u'参数不完整')
            return self.write_fail(code=ERROR.ARG_MISS, message='参数不完整')
        try:
            data = self.rpc['venus/sun/user/user_image_list'](
                user_id=user_id, offset=(offset - 1) * count, limit=count).unwrap()
        except Exception as e:
            error_logger.error(u'获取%s用户头像失败%s' % (user_id, e))
            raise
        return data
