import json
from utils.base import APIView, get_offset_count
from utils.logger import error_logger


class WordParentListView(APIView):

    def get(self, request):
        offset, count = get_offset_count(request)
        name = request.GET.get('name', None)
        is_online = request.GET.get('is_online', None)

        data = self.rpc['venus/sun/word_parent/list'](offset=offset, count=count, name=name, is_online=is_online).unwrap()
        return data


class WordParentInfoView(APIView):
    
    def get(self, request):
        
        id_ = request.GET.get('id')

        data = self.rpc['venus/sun/word_parent/get'](id_=id_).unwrap()
        return data


class WordParentCreateView(APIView):

    def post(self, request):

        data = {}
        data["name"] = request.POST.get('name', None)
        children_words = request.POST.get('children_words')
        data["children_words"] = json.loads(children_words) if children_words else []
        data["content_ad"] = request.POST.get('content_ad', None)
        data["makeup_ad"] = request.POST.get('makeup_ad', None)
        data["dress_ad"] = request.POST.get('dress_ad', None)
        data["gender"] = request.POST.get('gender', None)
        makeup_pictorial_ids = request.POST.get('makeup_pictorial_ids')
        clothing_pictorial_ids = request.POST.get('clothing_pictorial_ids')
        data["makeup_pictorial_ids"] = json.loads(makeup_pictorial_ids) if makeup_pictorial_ids else []
        data["clothing_pictorial_ids"] = json.loads(clothing_pictorial_ids) if clothing_pictorial_ids else []

        data = self.rpc['venus/sun/word_parent/add'](data=data).unwrap()

        return data


class WordParentUpdateView(APIView):
    
    def post(self, request):

        data = {}
        data["id"] = request.POST.get('id', None)
        data["name"] = request.POST.get('name', None)
        children_words = request.POST.get('children_words')
        data["children_words"] = json.loads(children_words) if children_words else []
        data["content_ad"] = request.POST.get('content_ad', None)
        data["makeup_ad"] = request.POST.get('makeup_ad', None)
        data["dress_ad"] = request.POST.get('dress_ad', None)
        data["gender"] = request.POST.get('gender', None)
        makeup_pictorial_ids = request.POST.get('makeup_pictorial_ids')
        clothing_pictorial_ids = request.POST.get('clothing_pictorial_ids')
        data["makeup_pictorial_ids"] = json.loads(makeup_pictorial_ids) if makeup_pictorial_ids else []
        data["clothing_pictorial_ids"] = json.loads(clothing_pictorial_ids) if clothing_pictorial_ids else []

        data = self.rpc['venus/sun/word_parent/edit'](data=data).unwrap()
        if not data:
            return r'更新失败'

        return data


class WordParentDeleteView(APIView):
    
    def post(self, request):
        ids = json.loads(request.POST.get('ids', '[]'))

        if not ids:
            return r'缺少参数'

        for id_ in ids:
            data = self.rpc['venus/sun/word_parent/delete'](id_=id_).unwrap()
            if not data:
                return r'操作失败'

        return data
