import request from '@/utils/request'

export function loginByUsername(username, password) {
  const data = {
    username,
    password
  }
  return request({
    url: '/api/account/login',
    method: 'post',
    data
  })
}

export function logout(data) {
  return request({
    url: '/api/account/logout',
    method: 'post',
    data
  })
}

export function getUserInfo(session_key) {
  return request({
    url: '/api/account/get',
    method: 'get',
    params: { session_key }
  })
}


