#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__ = "chenwei"
# Date: 2018/11/15

from utils.base import APIView


class PushListView(APIView):
    def get(self, request):
        page = request.GET.get('page', 1)
        limit = request.GET.get('limit', 10)
        filter = self.handle_filter(request.GET.get('filter', ""))
        try:
            data = self.rpc['venus/community/push/get'](offset=page, limit=limit, filters=filter).unwrap()
        except Exception as e:
            data = {
            'total': 200,
            'data': [
                {'id': 1, 'title': '测试1', 'content': '测试2', 'push_time': '2018-08-09','create_time':'2019-08-07', 'creator_id':22, },
                {'id': 2, 'title': '测试1', 'content': '测试2', 'push_time': '2018-08-09', 'create_time': '2019-08-07',
                 'creator_id': 22, },
                {'id': 3, 'title': '测试1', 'content': '测试2', 'push_time': '2018-08-09', 'create_time': '2019-08-07',
                 'creator_id': 22, },
            ]
        }

        return data