
import Layout from '@/views/layout/Layout'


const PickRouter = {
  path: '/pick',
  component: Layout,
  redirect: '/pick/list',
  name: 'Pick',
  meta: {
    title: 'Pick管理',
    icon: 'example'
  },
  children: [
    {
      path: 'list',
      component: () => import('@/views/pick/list'),
      name: 'PickList',
      meta: {title: 'Pick列表', icon: 'list'}
    },
    {
      path: 'create',
      component: () => import('@/views/pick/create'),
      name: 'CreatePick',
      meta: {title: '创建Pick', icon: 'edit'}
    },
    {
      path: 'edit/:id(\\d+)',
      component: () => import('@/views/pick/edit'),
      name: 'EditPick',
      meta: {title: '编辑Pick', noCache: true},
      hidden: true
    }
  ]
}

export default PickRouter
