
import Layout from '@/views/layout/Layout'


const GroupRouter = {
  path: '/user',
  component: Layout,
  redirect: '/user/list',
  name: 'User',
  meta: {
    title: '用户管理',
    icon: 'example'
  },
  children: [
    {
      path: 'list',
      component: () => import('@/views/user/list'),
      name: 'UserList',
      meta: {title: '用户列表', icon: 'list'}
    },
    {
      path: 'create',
      component: () => import('@/views/user/create'),
      name: 'CreateUser',
      meta: {title: '创建用户', icon: 'edit'}
    },
    {
      path: 'edit/:id(\\d+)',
      component: () => import('@/views/user/edit'),
      name: 'EditUser',
      meta: {title: '编辑用户', noCache: true},
      hidden: true
    }
  ]
}

export default GroupRouter
