#! /usr/bin/env python
# -*- coding: utf-8 -*-
# __author__ = "chenwei"
# Date: 2018/12/11

from utils.base import APIView

from utils.logger import error_logger


class FaceStarEdit(APIView):

    def get(self, request):

        _id = request.GET.get('id')
        try:
            data = self.rpc['mercury/face/star/get'](_id=_id).unwrap()
        except Exception as e:
            error_logger.error(u'获取 %d 明星信息失败 %s ' % (_id, e))
            raise

        return {'data': data}

    def post(self, request):
        _id = request.POST.get('id')
        name = request.POST.get('name')
        sex = request.POST.get('sex')
        ordinary_image_url = request.POST.get('ordinary_image_url')
        modeling_obj_url = request.POST.get('modeling_obj_url')
        try:
            self.rpc['mercury/face/create_star'](
                name=name,
                sex=sex,
                ordinary_image_url=ordinary_image_url,
                modeling_obj_url=modeling_obj_url,
                _id=_id
            ).unwrap()
        except Exception as e:
            raise e

        return {
            'message': '创建成功'
        }


class StarListView(APIView):

    def get(self, request):
        page = int(request.GET.get('page', 1))
        limit = int(request.GET.get('limit', 10))
        filter = self.handle_filter(request.GET.get('filter', ""))
        try:
            data = self.rpc['mercury/face/star/list'](offset=(page-1) * limit, limit=limit, filters=filter).unwrap()
        except Exception as e:
            error_logger.error(u'获取明星列表失败 %s', e)
            raise

        return data

    def post(self, request):
        ids = request.POST.get('ids', '').split()
        tp = request.POST.get('type', '')

        updates = {}

        if tp == 'offline':
            updates['is_online'] = 0
        else:
            updates['is_online'] = 1
        try:
            self.rpc['mercury/face/batch/update'](ids=ids, updates=updates).unwrap()
        except Exception as e:
            error_logger.error(u'批量更新明星列表失败 %s', e)
            raise
        return {
            "message": "更新成功"
        }
