from typing import Any, List
from fastapi_rpcd.all import Context, bind  # type: ignore
from fastapi_rpcd.all import get_current_rpc_invoker

from .schemas import LiveListRequest, LiveList, LiveInfo, LiveNoticeListRequest, LiveUser
from .format import LiveFormat


async def format_lives(version, device_id, res: List[Any]) -> LiveList:

    lives = LiveFormat(version, device_id).format_feed_card(lives=res)

    doctor_ids = [live.user.doctor_id for live in lives.lives if live.user.doctor_id]
    practice_time = (
        await get_current_rpc_invoker()['api/doctors/practice_time'](doctor_ids=doctor_ids)
    ).unwrap_or({})

    for live in lives.lives:
        if not live.user.doctor_id:
            continue

        _practice_year = practice_time.get(live.user.doctor_id, 0)
        if not _practice_year:
            continue

        live.user.doctor_practice_desc = '从业{}年'.format(_practice_year)

    return lives


@bind("card/live/list_by_ids")
async def live_list_by_ids(ctx: Context, request: LiveListRequest) -> LiveList:
    if not request.live_ids:
        return LiveList(lives=[])

    res = (await get_current_rpc_invoker()["mimas/live/get_clannels_url/audience"](
        ids=request.live_ids,
    )).unwrap()

    return await format_lives(request.version, request.device_id, res)


@bind("card/live_notice/list_by_ids")
async def live_notice_list_by_ids(ctx: Context, request: LiveNoticeListRequest) -> LiveList:
    if not request.live_notice_ids:
        return LiveList(lives=[])

    res = (await get_current_rpc_invoker()["mimas/live/get_live_notice_v2"](
        live_ids=request.live_notice_ids,
    )).unwrap()

    return await format_lives(request.version, request.device_id, res)
