from fastapi_rpcd.all import Context, bind  # type: ignore
from fastapi_rpcd.all import get_current_rpc_invoker

from .schemas import SpecialPoolListRequest, SpecialPoolList, VisualPageList, VisualPageListRequest
from .format import SpecialPoolFormat, VisualPageFormat


@bind("card/special_pool/list_by_ids")
async def special_pools(ctx: Context, request: SpecialPoolListRequest) -> SpecialPoolList:
    if not request.special_pool_ids:
        return SpecialPoolList(special_pools=[])

    res = (await get_current_rpc_invoker()["api/special_pool/info"](
        ids=request.special_pool_ids,
    )).unwrap()

    return SpecialPoolFormat(request.version, request.device_id).format_feed_card(special_pools=res)


@bind("card/visualpage/list_by_ids")
async def visualpages(ctx: Context, request: VisualPageListRequest) -> VisualPageList:
    if not request.visualpage_ids:
        return VisualPageList(visualpages=[])

    res = (await get_current_rpc_invoker()["poseidon/visual/get_visualpage_by_ids"](
        visualpage_ids=request.visualpage_ids,
    )).unwrap()

    visualpage_list = VisualPageFormat(request.version, request.device_id).format_feed_card(visual_pages=res)

    ids = [item.id for item in visualpage_list.visual_pages]
    res = await _get_hera_tab_operate_img(sorted(ids))
    for visualpage in visualpage_list.visual_pages:
        image_url = res.get(str(visualpage.id), '')
        visualpage.images.image_url = image_url

    return visualpage_list


async def _get_hera_tab_operate_img(virsual_page_ids):

    res = (await get_current_rpc_invoker()["api/hera_tab_operate/image"](
        ids=virsual_page_ids
    )).unwrap_or({})

    return res