import time
import asyncio

from fastapi_rpcd.all import Context, bind  # type: ignore
from fastapi_rpcd.all import get_current_rpc_invoker

from card.rpcd.batch_rpc import RPCCalls
from .schemas import DemoRequest, DemoResponse
from .schemas import DiaryListRequest, DiaryList
from .format import DiaryFormat



@bind("card/demo/mul")
async def card_demo_mul(ctx: Context, request: DemoRequest) -> DemoResponse:

    rpc_calls = RPCCalls()
    rpc_calls.add("query", "poseidon/promotion/commodity/promotion/query", commodity_ids=[1], user_id=1)
    rpc_calls.add("price", "poseidon/promotion/commodity/price", commodity_ids=[1], user_id=1)
    await rpc_calls.gather()

    query = rpc_calls["query"]
    price = rpc_calls["price"]

    resp = DemoResponse(
        service_name="card", process_time=int(time.time()),
        output=request.echo
    )

    return resp


@bind("card/diary/list_by_ids")
async def diary_list_by_ids(ctx: Context, request: DiaryListRequest) -> DiaryList:

    if not request.diary_ids:
        return DiaryList(diaries=[])

    user_id = request.user_id
    res = (await get_current_rpc_invoker()["diary/simple_diary_list"](
        diary_ids=request.diary_ids,
        user_id=user_id,
    )).unwrap()
    return DiaryFormat(request.version, request.device_id).format_feed_card(res)
