from typing import Dict, List

from gm_types.gaia import SEARCH_TAB_TYPE
from gm_upload.utils.image_utils import Picture

from card.views.schemas import User, Tag
from card.views.utils.tag import transform_tags
from card.libs.protocol import gm_protocol
from card.views.utils.format import BaseFormat
from .schemas import DiaryList, DiaryInfo


class DiaryFormat(BaseFormat):

    def format_feed_card(self, diary_list: List[Dict]) -> DiaryList:

        res: List[DiaryInfo] = []
        for item in diary_list:

            user = User(**item["user"])
            self.modify_user(user)
            item["user"] = user

            for image in item.get("images", []):
                image_url = Picture.get_aspectscale_path(image["image"])
                image["image_url"] = self.revert_image(image_url)

            diary: DiaryInfo = DiaryInfo(**item)
            diary.gm_url = gm_protocol.get_diary_detail(id=diary.id)

            tags_v3 = []
            tags = transform_tags(
                tags=item["tags"],
                tab_type=SEARCH_TAB_TYPE.DIARY,
                filter_free_tag=True,
                tags_v3=tags_v3,
            )
            diary.tags = [Tag(**tag) for tag in tags]

            if item.get("video_url", ""):
                diary.video = self.get_video(
                    video_cover=self.revert_image(item.get("video_cover", "")),
                    video_url=item.get("video_url", ""),
                    short_video_url=item.get("short_video_url", ""),
                )

            res.append(diary)

        return DiaryList(diaries=res)
