from fastapi_rpcd.all import Context, bind  # type: ignore
from fastapi_rpcd.all import get_current_rpc_invoker

from .schemas import AnswerListRequest, AnswerList, QuestionListRequest, QuestionList
from .format import AnswerFormat, QuestionFormat


@bind("card/answer/list_by_ids")
async def answer_list_by_ids(ctx: Context, request: AnswerListRequest) -> AnswerList:

    if not request.answer_ids:
        return AnswerList(answers=[])

    user_id = request.user_id
    res = (await get_current_rpc_invoker()["qa/question_answer/list_by_ids_v3"](
        answer_ids=request.answer_ids,
        user_id=user_id,
    )).unwrap()

    return AnswerFormat(request.version, request.device_id).format_feed_card(res)


@bind("card/question/list_by_ids")
async def question_list_by_ids(ctx: Context, request: QuestionListRequest) -> QuestionList:
    """此处禁止新功能开发，后续会弃用"""

    if not request.question_ids:
        return QuestionList(questions=[])

    res = (await get_current_rpc_invoker()["qa/question/get_data_list_by_ids"](
        ids=request.question_ids,
    )).unwrap()

    return QuestionFormat(request.version, request.device_id).format_feed_card(res)
