from enum import IntEnum
from typing import Any, List, Optional

from fastapi_rpcd.all import Schema
from pydantic import Field


class Video(Schema):
    """视频信息"""

    video_cover_url: str = Field(..., description="视频封面")
    video_url: str = Field(..., description="视频地址")
    short_video_url: str = Field(..., description="视频短视频url")
    width: Optional[int] = Field(0, description="封面图片宽")
    height: Optional[int] = Field(0, description="封面图片高")
