from typing import List, Optional

from fastapi_rpcd.all import Schema
from pydantic import Field

from card.views.schemas import User, Tag


class TractateListRequest(Schema):

    user_id: int = Field(None, description="当前用户ID")
    tractate_ids: List[int] = Field([], description="ID列表")
    version: Optional[str] = Field('', description="app版本")
    device_id: Optional[str] = Field('', description="设备ID")


class Media(Schema):

    video_cover_url: str = Field('', description="video_cover_url")
    short_video_url: str = Field('', description="short_video_url")
    image_webp: str = Field('', description="webp图片地址")
    height: int = Field(0, description="图片地址")
    width: int = Field(0, description="图片地址")
    image_url: str = Field(..., description="图片地址")


class TractateInfo(Schema):
    """问答信息"""

    id: int = Field(..., description="ID")
    title: str = Field(..., description="标题")
    content: str = Field(..., description="内容")
    is_voted: bool = Field(False, description="是否点赞")
    vote_num: int = Field(0, description="点赞数")
    reply_amount: int = Field(0, description="评论数")
    gm_url: str = Field(None, description="跳转协议")
    tags: Optional[List[Tag]] = Field([], description="标签")
    user: User = Field(..., description="用户信息")
    images: Optional[Media] = Field({}, description="图片")
    video: Optional[Media] = Field({}, description="视频")
    set_cover: bool = Field(False, description="是否设置封面")


class TractateList(Schema):
    """问答卡片列表信息"""

    tractates: Optional[List[TractateInfo]] =  Field([], description="列表")
