# -*- coding: utf-8 -*-
from typing import Optional
import aioredis  # type: ignore
from card import settings
from aioredis import ConnectionsPool  # type: ignore


class _LazyRedisPool:

    def __init__(self, redis_dsn: str, **options):
        self._pool: Optional[ConnectionsPool]  = None
        self._connected = False
        self._redis_dsn = redis_dsn
        self._options = options

    def __getattribute__(self, name):  # type: ignore

        if name.startswith("_"):
            return object.__getattribute__(self, name)

        return getattr(object.__getattribute__(self, '_pool'), name)

    async def _connect(self) -> None:
        """ 初始化 连接池. """
        self._pool = await aioredis.create_redis_pool(self._redis_dsn, **self._options)
        self._connected = True

    async def _disconnect(self) -> None:
        self._pool.close()
        await self._pool.wait_closed()
        self._connected = False


# fastapi 服务启动会通过 connect() 初始化为 aioredis.ConnectionsPool

redis_client = _LazyRedisPool(settings.REDIS_URL)
redis_client2 = _LazyRedisPool(settings.REDIS_URL2)
redis_client3 = _LazyRedisPool(settings.REDIS_URL3)
redis_client4 = _LazyRedisPool(settings.REDIS_URL4)
redis_ctr_push = _LazyRedisPool(settings.REDIS_URL4)
pool = _LazyRedisPool(settings.REDIS_URL3, maxsize=30)

# FIXME: aioredis 没有 decode_responses 参数,  需要注意该参数是否兼容以前的代码
#            `encoding`: Codec to use for response decoding.
decode_pool = _LazyRedisPool(settings.REDIS_URL3, maxsize=30, encoding="utf8")
lbs_redis_client = _LazyRedisPool(settings.LBS_REDIS_URL)


async def connect():
    """ 初始化 redis 连接池. """

    await redis_client._connect()
    await redis_client2._connect()
    await redis_client3._connect()
    await redis_client4._connect()
    await redis_ctr_push._connect()
    await pool._connect()
    await decode_pool._connect()
    await lbs_redis_client._connect()


async def disconnect():
    """ 销毁连接池 """
    await redis_client._disconnect()
    await redis_client2._disconnect()
    await redis_client3._disconnect()
    await redis_client4._disconnect()
    await redis_ctr_push._disconnect()
    await pool._disconnect()
    await decode_pool._disconnect()
    await lbs_redis_client._disconnect()
