from pkgutil import iter_modules, walk_packages
from inspect import getmembers

from card import views
from card.settings import IGNORE_VIEW_PATHS
from card.utils.log_utils import info_logger


def registe_views():
    """导入相关模块"""

    for mod_info in walk_packages(views.__path__,
                                  prefix=views.__name__+'.',
                                  onerror=lambda x: None):

        if mod_info.ispkg or mod_info.name.split('.')[-1] in IGNORE_VIEW_PATHS:
            continue

        info_logger.info(
            "Loading views in module: {} ...".format(mod_info.name))
        __import__(mod_info.name)
