from collections import defaultdict

from gm_types.gaia import TAG_TYPE, TAG_VERSION

from card import settings
from card.libs.protocol import gm_protocol

def feed_tag_v3_show_filter(tags):
    """feed按标签类型过滤需要展示的v3标签"""

    type2tag = defaultdict(list)
    for tag in tags:
        tag_type = tag["tag_type"]
        if tag_type in settings.FEED_SHOW_TAG_TYPES:
            type2tag[tag_type].append(tag)

    tags_filtered_sorted = []
    for tag_type in settings.FEED_SHOW_TAG_TYPES:
        tags_filtered_sorted.extend(type2tag[tag_type])

    return tags_filtered_sorted


def transform_tags(tags, tab_type, filter_free_tag=False, tags_v3=[]):

    if tags_v3:
        tags_v3 = feed_tag_v3_show_filter(tags_v3)
        if tags_v3:
            tag = tags_v3[0]
            tag["gm_url"] = gm_protocol.get_polymer_detail(
                tag_id=tag["id"], new_tag=TAG_VERSION.V3
            )
            return [tag]

    tags = filter(lambda item: item["id"] != settings.VIDEO_TAG_ID, tags)

    exclude_tag_types = [TAG_TYPE.CITY, TAG_TYPE.PROVINCE, TAG_TYPE.COUNTRY]
    tags = list(filter(lambda item: item["type"] not in exclude_tag_types, tags))
    if filter_free_tag:
        tags = list(filter(lambda item: not item["type"] == TAG_TYPE.FREE, tags))

    tags.sort(key=lambda x: (x["type"] != TAG_TYPE.YUNYING, -x["id"]))
    if not tags:
        return []

    tag = tags[0]
    if tag["type"] == TAG_TYPE.YUNYING:  # or hit_gray(self.version, Rules.NEW_POLYMER)
        tag["gm_url"] = gm_protocol.get_polymer_detail(tag_id=tag["id"])
    else:
        tag["gm_url"] = gm_protocol.get_search_result(query=tag["name"], tab_type=tab_type)
    return [tag]