import logging
import logging.config
import traceback

import sentry_sdk  # type: ignore

exception_logger = logging.getLogger("exception_logger")
info_logger = logging.getLogger("info_logger")
err_logger = logging.getLogger("error_logger")
sql_logger = logging.getLogger("sql_logger")


def logging_exception():
    traceback.format_exc()
    err_logger.error(traceback.format_exc())
    try:
        sentry_sdk.capture_exception()
    except:
        pass


def configure_logging():
    """ 日志组件初始化. """
    from card.log_settings import LOGGING

    logging.config.dictConfig(LOGGING)

def log_response(url):
    import functools
    def fun_tool(f):
        result = None
        @functools.wraps(f)
        async def wrapped(*args):
            nonlocal result,url
            try:
                result =await f(*args)
                info_logger.info("{} request_params:{} response:{}".format(url,args[1].dict(),result))
                return result
            except:
                logging_exception()
                return result
        return wrapped
    return fun_tool