from fastapi_rpcd.all import Context, bind  # type: ignore
from fastapi_rpcd.all import get_current_rpc_invoker

from .schemas import AnswerListRequest, AnswerList
from .format import AnswerFormat


@bind("card/answer/list_by_ids")
async def diary_list_by_ids(ctx: Context, request: AnswerListRequest) -> AnswerList:

    if not request.answer_ids:
        return AnswerList(answers=[])

    user_id = request.user_id
    res = (await get_current_rpc_invoker()["qa/question_answer/list_by_ids_v3"](
        answer_ids=request.answer_ids,
        # user_id=user_id,
    )).unwrap()

    return AnswerFormat(request.version, request.device_id).format_feed_card(res)
