from typing import List, Optional

from fastapi_rpcd.all import Schema
from pydantic import Field


class SpecialPoolListRequest(Schema):

    special_pool_ids: List[int] = Field([], description="ID列表")
    version: Optional[str] = Field('', description="app版本")
    device_id: Optional[str] = Field('', description="设备ID")

class VisualPageListRequest(Schema):

    visualpage_ids: List[int] = Field([], description="ID列表")
    version: Optional[str] = Field('', description="app版本")
    device_id: Optional[str] = Field('', description="设备ID")


class Image(Schema):

    height: int = Field(0, description="图片地址")
    width: str = Field(0, description="图片地址")
    image_url: str = Field(..., description="图片地址")


class SpecialPoolInfo(Schema):
    """自定义专题信息"""

    id: int = Field(..., description="ID")
    visual_page_id: int = Field(..., description="自定义专题ID")
    content: str = Field(..., description="内容")
    gm_url: str = Field(None, description="跳转协议")
    images: Optional[Image] = Field({}, description="图片")


class SpecialPoolList(Schema):
    """自定义专题信息列表"""

    special_pools: Optional[List[SpecialPoolInfo]] =  Field([], description="列表")


class VisualPageInfo(Schema):
    """自定义专题信息"""

    id: int = Field(..., description="ID")
    content: str = Field(..., description="内容")
    gm_url: str = Field(None, description="跳转协议")
    images: Optional[Image] = Field({}, description="图片")


class VisualPageList(Schema):
    """自定义专题信息列表"""

    visual_pages: Optional[List[VisualPageInfo]] =  Field([], description="列表")
