from typing import Optional
from gm_types.gaia import USER_TYPE

from card.views.schemas import User, Video
from card.libs.protocol import gm_protocol
from card import settings


class BaseFormat(object):

    @classmethod
    def revert_image(cls, image):
        """传入图片地址，返回原图（不带后缀）"""
        if not image:
            return ""

        return image.rsplit('-', 1)[0]

    @classmethod
    def modify_user(cls, user: User) -> User:

        if user.user_type == USER_TYPE.NORMAL:
            user.gm_url = gm_protocol.get_user_homepage(user.user_id)
        elif user.user_type == USER_TYPE.EXPERT:
            user.user_level.membership_icon = settings.EXPERT_MEMBERSHIP_IMG
            user.gm_url = gm_protocol.get_expert_home(user.doctor_id)

    @classmethod
    def get_video(cls,
                  video_cover: str, video_url: str, short_video_url: str,
                  width: Optional[int]=0, height: Optional[int]=0) -> Video:

        return Video(
            **{
                "video_cover_url": cls.revert_image(video_cover),
                "video_url": video_url,
                "short_video_url": short_video_url,
                "width": width,
                "height": height,
            }
        )
