# -*- coding: utf-8 -*-
import asyncio
import sentry_sdk

from card import settings
from card.utils import redis


async def startup_redis_pool():
    await redis.connect()


async def shutdown_redis_pool():
    await redis.disconnect()


async def sentry_sdk_init():
    """ 初始化 sentry. """
    try:
        sentry_sdk.init(settings.RAVEN_CONFIG["dsn"])
    except:
        pass


fastapi_on_startup = [startup_redis_pool, sentry_sdk_init]
fastapi_on_shutdown = [shutdown_redis_pool]
