from typing import List

from gm_types.gaia import USER_TYPE, LIVE_STATUS
from gm_types.merchant.live import LIVE_PLAYER_ENTRANCE

from card import settings
from card.libs.protocol import gm_protocol
from card.views.utils.format import BaseFormat
from .schemas import LiveInfo, LiveList


class LiveFormat(BaseFormat):

    def __init__(self, version, device_id):
        self.version = version
        self.device_id = device_id

    @classmethod
    def _get_live_gm_url(cls, status, topic_id, channel_id):
        """获取直播相关的gm_url。"""

        gm_url = ''
        if status == LIVE_STATUS.NOLIVE:
            gm_url = gm_protocol.get_live_playback(topic_id=topic_id)

        elif status == LIVE_STATUS.LIVE:
            gm_url = gm_protocol.get_live_list(channel_id=channel_id, entrance=LIVE_PLAYER_ENTRANCE.FEED)

        elif status == LIVE_STATUS.NOTICE:
            url = settings.API_HOST + "/hybrid/broadcast/prevue/"
            gm_url = gm_protocol.get_webview(url)

        return gm_url

    def format_live(self, info):
        """直播、预告信息"""

        live = {
            "id": info["id"],
            "notice_id": info.get("conf_id"),
            "channel_id": info.get("channel_id"),
            "stream_id": info.get("stream_id"),
            "status": info.get("status"),
            "zhibo_time": info.get("zhibo_time", 0),
            "topic_id": info.get("topic_id"),
            "images": {
                "image_url": self.revert_image(info.get("cover_url", '')),
                "height": info.get("height", 0),
                "width": info.get("width", 0),
            },
            "content": info.get("desc", '') or info.get("title", ''),
        }

        user = {
            "user_id": info.get("user_id"),
            "user_name": info.get("uname", ""),
            "portrait": info.get("user_portrait", ""),
            "user_level": info.get("user_level", {}),
            "user_type": USER_TYPE.NORMAL,
            "gm_url": gm_protocol.get_user_homepage(info.get("user_id")),
        }
        if info.get("doctor"):
            _did = info.get('doctor', {}).get('id')
            user["doctor_id"] = _did
            user["user_type"] = USER_TYPE.EXPERT
            user["user_level"]["membership_icon"] = settings.EXPERT_MEMBERSHIP_IMG
            user["gm_url"] = gm_protocol.get_expert_home(_did)
        live["user"] = user

        if live["status"] == LIVE_STATUS.NOLIVE and not live["topic_id"]:
                return None

        live["gm_url"] = self._get_live_gm_url(live["status"], live["topic_id"], live["channel_id"])

        return LiveInfo(**live)

    def format_feed_card(self, lives) -> LiveList:

        res: List[LiveInfo] = []
        for item in lives:
            live = self.format_live(info=item)
            if live:
                res.append(live)

        return LiveList(lives=res)
