from fastapi_rpcd.all import Context, bind  # type: ignore
from fastapi_rpcd.all import get_current_rpc_invoker

from .schemas import TractateListRequest, TractateList
from .format import TractateFormat


@bind("card/tractate/list_by_ids")
async def diary_list_by_ids(ctx: Context, request: TractateListRequest) -> TractateList:
    if not request.tractate_ids:
        return TractateList(tractates=[])

    user_id = request.user_id
    res = (await get_current_rpc_invoker()["mimas/tractate/list_by_ids"](
        tractate_ids=request.tractate_ids,
        need_special_info=True,
        # user_id=user_id,
    )).unwrap()

    tractates = res.get("tractate_list", [])

    return TractateFormat(request.version, request.device_id).format_feed_card(tractate_list=tractates)
