import time
import asyncio
from typing import List, Any, Dict

from fastapi_rpcd.all import Context, bind  # type: ignore
from fastapi_rpcd.all import AsyncRPCInvoker, get_current_rpc_invoker


class RPC(object):

    def __init__(self, name: str, method: str, future: Any, **kwargs: Any) -> None:
        self.name: str = name
        self.method: str = method
        self.kwargs: Dict = kwargs
        self.future: Any = future


class RPCCalls(object):
    """rpc批量请求"""

    def __init__(self):

        self.client: AsyncRPCInvoker = get_current_rpc_invoker()
        self.rpcs: Dict[str, RPC] = {}
        self._done: bool = False
        self.result: Dict[str, Any] = {}

    def add(self, name: str, method: str, **kwargs: Any) -> None:

        future = self.client[method](**kwargs)
        rpc = RPC(name=name, method=method, future=future, **kwargs)

        self.rpcs[name] = rpc

    def __getitem__(self, name: str) -> Any:

        if name not in self.rpcs:
            raise Exception("method not found")

        if not self._done:
            raise Exception("those rpcs must gather before use them")

        future = self.result[name]
        return future.unwrap()

    async def gather(self) -> List:
        futures_dict = {rpc.name: rpc.future for rpc in self.rpcs.values()}
        self._done = True

        names, futures = [], []
        for name, future in futures_dict.items():
            names.append(name)
            futures.append(future)

        for idx, item in enumerate(await asyncio.gather(*futures)):
            self.result[names[idx]] = item
