from typing import List, Optional

from fastapi_rpcd.all import Schema
from pydantic import Field

from card.views.schemas import User, Tag, Video


class DemoRequest(Schema):

    echo: str = Field(..., description="输入参数")


class DemoResponse(Schema):

    service_name: str = Field(..., description="服务名字")
    process_time: int = Field(..., description="服务处理时间")
    output: str = Field(..., description="输出参数")


class DiaryListRequest(Schema):

    user_id: int = Field(None, description="当前用户ID")
    diary_ids: List[int] = Field([], description="日记本ID列表")
    version: str = Field(None, description="当前app version")
    device_id: str = Field(None, description="当前用户设备ID")


class DiaryImage(Schema):

    image_url: str = Field(..., description="图片地址")
    desc: str = Field(..., description="描述：Before/After")
    # "image_wide": "https://pic.igengmei.com/2018/11/03/1623/99b3374ffe11-wide",
    # "image_slimwidth": "https://pic.igengmei.com/2018/11/03/1623/99b3374ffe11-slimwidth",
    # "small_wide": "https://pic.igengmei.com/2018/11/03/1623/99b3374ffe11-smallwide",
    # "image_thumb": "https://pic.igengmei.com/2018/11/03/1623/99b3374ffe11-thumb",
    # "image_half": "https://pic.igengmei.com/2018/11/03/1623/99b3374ffe11-half",


class DiaryInfo(Schema):
    """日记本信息"""

    id: int = Field(..., description="日记本ID")
    title: str = Field(..., description="日记本标题")
    content: str = Field(..., description="内容")
    service_id: str = Field(None, description="日记关联美购ID")
    is_voted: bool = Field(False, description="是否点赞")
    vote_num: int = Field(0, description="点赞数")
    reply_num: int = Field(0, description="评论数")
    gm_url: str = Field(None, description="跳转协议")
    tags: Optional[List[Tag]] = Field([], description="标签")
    user: User = Field(..., description="用户信息")
    images: Optional[List[DiaryImage]] = Field([], description="术前术后图")
    video: Optional[Video] = Field({}, description="日记视频")


class DiaryList(Schema):
    """日记本卡片列表信息"""

    diaries: Optional[List[DiaryInfo]] =  Field([], description="日记本列表")
