from card.views.schemas import video
import random
from typing import List

from gm_types.gaia import SEARCH_TAB_TYPE
from gm_upload.utils.image_utils import Picture

from card.views.utils.html import gm_decode_html
from card.views.schemas import User, Tag
from card.views.utils.tag import transform_tags
from card.libs.protocol import gm_protocol
from card.views.utils.format import BaseFormat
from .schemas import AnswerList, AnswerInfo, QuestionList, QuestionInfo, QuestionImage
from .default_pic import default_pic


class AnswerFormat(BaseFormat):

    @classmethod
    def deal_with_pic_hex(cls, image):

        if image.get("image_url"):
            return image

        pic_info = random.choice(default_pic)

        return pic_info

    def format_feed_card(self, answer_list) -> AnswerList:

        res: List[AnswerInfo] = []
        for item in answer_list:

            user = User(**item["user"])
            self.modify_user(user)
            item["user"] = user

            answer: AnswerInfo = AnswerInfo(**item)
            answer.content = gm_decode_html(answer.content)
            answer.gm_url = gm_protocol.get_question_detail(item["question_id"], top_answer_id=item["answer_id"])

            tags_v3 = []
            tags = transform_tags(
                tags=item["tags"],
                tab_type=SEARCH_TAB_TYPE.ALL,
                filter_free_tag=True,
                tags_v3=tags_v3,
            )
            answer.tags = [Tag(**tag) for tag in tags]

            _intact_answer_images = item.pop("intact_answer_images", [])
            _question_intact_question_images = item.pop("question_intact_question_images", [])
            header_images = item.pop('header_images', [])

            _image = {}
            if item.get("cover_url"):
                _image = {
                    "image": item.get("cover_url"),
                }

            elif header_images:
                _image = header_images[0]
            elif _intact_answer_images:
                _image = _intact_answer_images[0]
            elif _question_intact_question_images:
                _image = _question_intact_question_images[0]

            if _image:
                image_url = Picture.get_aspectscale_path(_image.pop("image", ""))
                _image["image_url"] = self.revert_image(image_url)

            image = self.deal_with_pic_hex(_image)
            answer.images = image # 此处是一个image对象

            video_info = {}
            if item.get("video_cover_list"):
                video_info = item.get("video_cover_list")[0]
            elif item.get("question_videos"):
                video_info = item.get("question_videos")[0]

            if video_info.get("video_url", ''):
                video = self.get_video(
                    video_cover=self.revert_image(video_info.get("video_pic", '')),
                    video_url=video_info.get("video_url", ''),
                    short_video_url=video_info.get("short_video_url", ''),
                    width=video_info.get("width", 0),
                    height=video_info.get("height", 0),
                )
                answer.video = video

            res.append(answer)

        return AnswerList(answers=res)


class QuestionFormat(AnswerFormat):
    """此处禁止新功能开发"""

    def format_feed_card(self, question_list) -> QuestionList:

        res: List[QuestionInfo] = []
        for item in question_list.values():

            question = QuestionInfo(**item)
            question.gm_url = gm_protocol.get_question_detail(item["question_id"])

            tags = transform_tags(
                tags=item["tags"],
                tab_type=SEARCH_TAB_TYPE.ALL,
                filter_free_tag=True,
                tags_v3=[],
            )
            question.tags = [Tag(**tag) for tag in tags]

            _intact_images = item.pop("intact_question_images", [])
            header_images = item.pop('header_images', [])
            if header_images:
                _image = header_images[0]
            else:
                _image = _intact_images and _intact_images[0] or {}
            if _image:
                _image["image_url"] = self.revert_image(Picture.get_aspectscale_path(_image.pop("image", "")))

            question.images = QuestionImage(**self.deal_with_pic_hex(_image))

            video_item = item.get("video_cover_list") and item.get("video_cover_list")[0] or {}
            question.video_url = video_item.get("video_url", "")
            question.video_pic = video_item.get("video_pic", "")
            question.short_video_url = video_item.get("short_video_url", "")

            # question.images.video_url = question.video_url
            # question.images.video_pic = question.video_pic
            # question.images.short_video_url = question.short_video_url

            question.content = gm_decode_html(item.pop("row_content", ""))

            res.append(question)

        return QuestionList(questions=res)
