from typing import List

from card.settings import settings
from card.libs.protocol import gm_protocol
from card.views.utils.format import BaseFormat
from .schemas import SpecialPoolInfo, SpecialPoolList, VisualPageInfo, VisualPageList


class SpecialPoolFormat(BaseFormat):

    def format_special_pool(self, info):

        special_pool = {
            "id": info["id"],
            "visual_page_id": info["visual_page_id"],
            "content": '',
            "images": {
                "width": 350,
                "height": 350,
                "image_url": info.get("home_feed_cover_image", ''),
            },
            "gm_url": gm_protocol.get_webview(settings.API_HOST +
                                                '/phantom/visual_special/{}?usepage=wk'.format(info["visual_page_id"]))
        }

        return SpecialPoolInfo(**special_pool)

    def format_feed_card(self, special_pools) -> SpecialPoolList:

        res: SpecialPoolList = []
        for item in special_pools:
            res.append(self.format_special_pool(info=item))

        return SpecialPoolList(special_pools=res)

class VisualPageFormat(BaseFormat):

    def format_visual_page(self, info):

        visual_page = {
            "id": info["id"],
            "content": '',
            "images": {
                "width": 350,
                "height": 350,
                "image_url": info.get("home_feed_cover_image", ''),
            },
            "gm_url": gm_protocol.get_webview(settings.API_HOST +
                                                '/phantom/visual_special/{}?usepage=wk'.format(info["id"]))
        }

        return VisualPageInfo(**visual_page)

    def format_feed_card(self, visual_pages) -> VisualPageList:

        res: List[VisualPageInfo] = []
        for item in visual_pages:
            res.append(self.format_visual_page(info=item))

        return VisualPageList(visual_pages=res)
