from enum import IntEnum
from typing import Any, List, Optional

from fastapi_rpcd.all import Schema
from pydantic import Field


class UserTypeEnum(IntEnum):
    NORMAL = 0  # 普通用户
    EXPERT = 1  # 专家
    OFFICER = 2  # 机构


class UserTypeEnum(IntEnum):
    NORMAL = 0  # 通用户
    EXPERT = 1  # 专家
    OFFICER = 2  # 机构


class UserLevel(Schema):

    membership_icon: str = Field(None, description="达人icon")
    level_icon: str = Field(None, description="等级icon")
    constellation_icon: str = Field(None, description="星座icon")


class User(Schema):
    """用户信息"""

    id: int = Field(None, description="用户ID")
    user_id: int = Field(None, description="用户ID")
    user_name: str = Field(None, description="用户名")
    portrait: str = Field(None, description="用户头像")
    gm_url: str = Field(None, description="用户协议跳转")
    user_type: UserTypeEnum = Field(..., description="用户类型, 0:普通用户, 1:专家, 2:机构")
    doctor_id: str = Field(None, description="医生ID")
    hospital_id: Optional[str] = Field(None, description="医院ID")
    membership_level: Optional[str] = Field(None, description="用户名")
    user_level:  UserLevel= Field(None, description="用户Level相关信息")
