# -*- coding: utf-8 -*-
from typing import Any, Dict, Optional

from fastapi_rpcd.all import Schema  # type: ignore
from fastapi_rpcd.all import RPCDFaultException, get_current_rpc_invoker
from gm_types.error import ERROR  # type: ignore


class User(Schema):

    user_id: Optional[int] = None
    person_id: Optional[str] = None
    nick_name: Optional[str] = None
    portrait: Optional[str] = None
    last_name: Optional[str] = None


def gen(code):
    raise RPCDFaultException(
        code=code, message=ERROR.getDesc(code),
    )


def dict_to_user_obj(user_dict: Dict[str, Any]) -> User:
    return User(**user_dict)


async def get_current_logined_user() -> Optional[User]:
    client_context = get_current_rpc_invoker()
    try:
        defered = await client_context["passport/info/by_session"]()
        res = defered.unwrap()
    except Exception:
        return None
    return dict_to_user_obj(res)
