from typing import List, Optional

from fastapi_rpcd.all import Schema
from pydantic import Field

from card.views.schemas import User, UserTypeEnum, UserLevel, Tag, Video


class AnswerListRequest(Schema):

    user_id: int = Field(None, description="当前用户ID")
    answer_ids: List[int] = Field([], description="问答ID列表")
    version: Optional[str] = Field('', description="app版本")
    device_id: Optional[str] = Field('', description="设备ID")


class QaImage(Schema):

    image_url: str = Field(..., description="图片地址")
    image_webp: str = Field(..., description="webp图片地址")
    height: int = Field(0, description="图片地址")
    width: str = Field(0, description="图片地址")


class AnswerInfo(Schema):
    """问答信息"""

    id: int = Field(..., description="问答ID")
    title: str = Field(..., description="问答标题")
    content: str = Field(..., description="内容")
    is_voted: bool = Field(False, description="是否点赞")
    vote_num: int = Field(0, description="点赞数")
    answer_num: int = Field(0, description="对应问题回答数")
    comment_num: int = Field(0, description="评论数")
    gm_url: str = Field(None, description="跳转协议")
    tags: Optional[List[Tag]] = Field([], description="标签")
    user: User = Field(..., description="用户信息")
    images: Optional[QaImage] = Field({}, description="图片")
    video: Optional[Video] = Field({}, description="日记视频")


class AnswerList(Schema):
    """问答卡片列表信息"""

    answers: Optional[List[AnswerInfo]] =  Field([], description="问答列表")


class QuestionListRequest(Schema):

    question_ids: List[int] = Field([], description="问题ID列表")
    version: Optional[str] = Field('', description="app版本")
    device_id: Optional[str] = Field('', description="设备ID")


class QuestionImage(Schema):

    video_pic: Optional[str] = Field('', description="图片地址")
    video_url: Optional[str] = Field('', description="视频地址")
    short_video_url: Optional[str] = Field('', description="短视频地址")
    image_url: str = Field(..., description="图片地址")
    image_webp: str = Field(..., description="webp图片地址")
    height: int = Field(0, description="图片地址")
    width: str = Field(0, description="图片地址")

class VideoCoverList(Schema):

    video_pic: Optional[str] = Field('', description="图片地址")
    video_url: Optional[str] = Field('', description="视频地址")
    short_video_url: Optional[str] = Field('', description="短视频地址")
    height: int = Field(0, description="图片地址")
    width: str = Field(0, description="图片地址")


class QuestionInfo(Schema):
    """问答信息"""

    id: int = Field(..., description="问题ID")
    title: str = Field(..., description="问题标题")
    content: str = Field(..., description="内容")
    gm_url: str = Field(None, description="跳转协议")

    is_voted: bool = Field(False, description="是否点赞")
    answer_num: int = Field(0, description="对应问题回答数")
    view_num: int = Field(0, description="浏览数")
    tags: Optional[List[Tag]] = Field([], description="标签")

    images: Optional[QuestionImage] = Field({}, description="图片")

    user_id: int = Field(None, description="用户ID")
    user_name: str = Field(None, description="用户名")
    user_portrait: str = Field(None, description="用户头像")  # portrait
    membership_level: Optional[str] = Field(None, description="用户名")
    user_level:  UserLevel = Field(None, description="用户Level相关信息")

    # video_cover_list: Optional[VideoCoverList] = Field({}, description="视频")
    video_pic: Optional[str] = Field('', description="视频图片地址")
    cover_url: Optional[str] = Field('', description="封面地址")
    video_url: Optional[str] = Field('', description="视频地址")
    short_video_url: Optional[str] = Field('', description="短视频地址")


class QuestionList(Schema):
    """问题卡片列表信息"""

    questions: Optional[List[QuestionInfo]] =  Field([], description="问题列表")
