from typing import List, Optional

from fastapi_rpcd.all import Schema
from pydantic import Field

from card.views.schemas import User


class LiveListRequest(Schema):

    user_id: Optional[int] = Field(None, description="用户ID")
    live_ids: List[int] = Field([], description="ID列表")
    version: Optional[str] = Field('', description="app版本")
    device_id: Optional[str] = Field('', description="设备ID")

class LiveNoticeListRequest(Schema):

    user_id: Optional[int] = Field(None, description="用户ID")
    live_notice_ids: List[int] = Field([], description="ID列表")
    version: Optional[str] = Field('', description="app版本")
    device_id: Optional[str] = Field('', description="设备ID")


class Image(Schema):

    height: int = Field(0, description="图片地址")
    width: int = Field(0, description="图片地址")
    image_url: str = Field(..., description="图片地址")


class LiveUser(User):

    doctor_practice_desc: Optional[str] = Field('', description="从业n年")
    doctor_id: Optional[str] = Field(None, description="从业n年")


class LiveInfo(Schema):
    """直播相关信息"""

    id: int = Field(..., description="ID")
    notice_id: Optional[int] = Field(None, description="预告ID")
    content: str = Field(..., description="内容")
    gm_url: str = Field(None, description="跳转协议")
    user: Optional[LiveUser] = Field({}, description="用户信息")
    id: int = Field(..., description="ID")
    zhibo_time: Optional[int] = Field(0, description="直播时间")
    images: Optional[Image] = Field({}, description="图片")
    topic_id: Optional[int] = Field(None, description="关联帖子ID")
    status: Optional[int] = Field(None, description="关联帖子ID")
    stream_id: Optional[int] = Field(None, description="stream id")
    channel_id: Optional[int] = Field(None, description="channel id")


class LiveList(Schema):
    """直播相关信息列表"""

    lives: Optional[List[LiveInfo]] =  Field([], description="列表")
