from zipkin import Zipkin, ZIPKIN_VERION
from zipkin import parse, list_exc_info

if __name__ == "__main__":
    domain = "http://zipkin.gengmei.tx"
    client = Zipkin(domain, version=ZIPKIN_VERION.V2)
    # 当前时间30s之内产生的错误
    traces_data = client.traces(service_name='backend', error=True, lookback=30 * 1000)

    traces = parse(traces_data)
    infos = list_exc_info(traces)
    if infos:
        for service_name, exc_infos in infos.items():
            print("接口：{}".format(service_name))
            for info in exc_infos:
                print("异常信息:{}".format(info))

        raise Exception("服务异常...")
