import json
from collections import defaultdict

from zipkin.span import Span, Endpoint, Annotation, BinaryAnnotation
from zipkin.trace import Trace

exc_info_key = "exc.info"

def parse(traces_data):

    traces = []
    for trace_data in traces_data:

        spans = []
        for span_data in trace_data:
            span = Span(**span_data)

            annotations_data = span_data.get("annotations", [])
            annotations = []
            for annotation_data in annotations_data:
                annotation = Annotation(**annotation_data)
                annotation.endpoint = Endpoint(**annotation_data.get("endpoint"))
                annotations.append(annotation)

            span.annotations = annotations

            binaryAnnotations_data = span_data.get("binaryAnnotations", [])
            binaryAnnotations = []
            for binaryAnnotation_data in binaryAnnotations_data:
                binaryAnnotation = BinaryAnnotation(**binaryAnnotation_data)
                binaryAnnotation.endpoint = Endpoint(**annotation_data.get("endpoint"))
                binaryAnnotations.append(binaryAnnotation)

            span.binaryAnnotations = binaryAnnotations

            spans.append(span)

        traces.append(Trace(spans=spans))

    return traces


def list_exc_info(traces):

    exc_infos = defaultdict(list)
    for trace in traces:
        for span in trace.spans:
            service_name = span.name
            for item in span.binaryAnnotations:
                if item.key != exc_info_key:
                    continue

                exc_infos[service_name].append(item.value)

    return exc_infos
