# -*- coding: utf-8 -*-
from enum import Enum

class HuanXinError(str, Enum):
    HUAN_XIN_SERVER_ERROR = 'huanxin server error' # 返回数据格式不是json

    REQUEST_ENTITY_TOO_LARGE = 'Request Entity Too Large'
    AUTH_BAD_ACCESS_TOKEN = 'auth_bad_access_token'
    DUPLICATE_UNIQUE_PROPERTY_EXISTS = 'duplicate_unique_property_exists'
    FORBIDDEN_OP = 'forbidden_op'
    ILLEGAL_ARGUMENT = 'illegal_argument'
    INVALID_GRANT = 'invalid_grant'
    INVALID_PARAMETER = 'invalid_parameter'
    JSON_PARSE = 'json_parse'
    NO_FULL_TEXT_INDEX = 'no_full_text_index'
    ORGANIZATION_APPLICATION_NOT_FOUND = 'organization_application_not_found'
    REACH_LIMIT = 'reach_limit'
    REQUIRED_PROPERTY_NOT_FOUND = 'required_property_not_found'
    RESOURCE_LIMITED = 'resource_limited'
    SERVICE_RESOURCE_NOT_FOUND = 'service_resource_not_found'
    STORAGE_OBJECT_NOT_FOUND = 'storage_object_not_found'
    UNAUTHORIZED = 'unauthorized'
    UNSUPPORTED_SERVICE_OPERATION = 'unsupported_service_operation'
    WEB_APPLICATION = 'web_application'
