# -*- coding: utf-8 -*-
from typing import Optional, Dict

from gm_types.passport import ERROR
from helios import RPCFaultException

from rpc_framework import exceptions
from .context import get_rpc_remote_invoker


def get_user_info_by_session(session_id: str) -> Optional[Dict]:
    try:
        return get_rpc_remote_invoker()(session_key=session_id)['passport/info/by_session']().unwrap()
    except RPCFaultException as e:
        if e.error == ERROR.ILLEGAL_SESSION:
            raise exceptions.RPCLoginRequiredException
    except Exception as e:
        return {}