# -*- coding: utf-8 -*-
import gm_rpcd
from gm_rpcd.internals.dynamic_scopes import Keys, dynamic_scope


class RPCAbstractView(object):

    def __init__(self, **kwargs):
        for key, value in kwargs.items():
            setattr(self, key, value)

    @classmethod
    def rpc_bind(cls, **initkwargs):
        """
        Store the original class on the view function.

        This allows us to discover information about the view when we do URL
        reverse lookups.  Used for breadcrumb generation.
        """
        def view(*args, **kwargs):
            self = cls(**initkwargs)
            # context = gm_rpcd.all.context
            context = dynamic_scope.get(Keys.CONTEXT)
            self.setup(context, *args, **kwargs)
            return self.dispatch(context, *args, **kwargs)

        view.view_class = cls
        view.view_initkwargs = initkwargs
        # avoid exception raise at gm_rpcd/internals/object_resolution_tables.py:62
        view.__name__ = cls.__name__
        view.__module__ = cls.__module__

        gm_rpcd.all.bind(cls.endpoint)(view)
        return view

    def setup(self, context, *args, **kwargs):
        """Initialize attributes shared by all view methods."""
        self.context = context
        self.args = args
        self.kwargs = kwargs

    def dispatch(self, context, *args, **kwargs):
        # print(type(context)) # gm_rpcd.internals.proxy_object.ProxyObject
        # assert isinstance(context, Context), 'context must be instance of gm_rpcd.internals.context.Context'
        return self.handler(context, *args, **kwargs)
