from __future__ import unicode_literals

from gm_types.error import ERROR as CODES


class GaiaRPCFaultException(Exception):

    def __init__(self, error, message, data):
        self.error = error
        self.message = message
        self.data = data

    def __repr__(self):
        return "Error %d, %s" % (self.error, self.message)


class UniError(GaiaRPCFaultException):
    def __init__(self, message):
        self.error = CODES.UNIVERSAL
        self.message = message
        self.data = None


class GaiaRPCSpecificExceptionBase(GaiaRPCFaultException):

    error = None
    default_message = None

    def __init__(self, message=None, data=None):
        error = self.error
        if message is None:
            message = self.default_message
        super(GaiaRPCSpecificExceptionBase, self).__init__(error=error, message=message, data=data)


class RPCPermanentError(GaiaRPCSpecificExceptionBase):

    error = 2
    default_message = "Permanent Error"


class RPCTemporaryError(GaiaRPCSpecificExceptionBase):

    error = 3
    default_message = "Temporary Error"


class RPCValidationError(GaiaRPCSpecificExceptionBase):

    error = 17
    default_message = "Params/Result Validation Error"


class RPCLoginRequiredException(GaiaRPCSpecificExceptionBase):

    error = 401
    default_message = "Login Required"


class RPCPermissionDeniedException(GaiaRPCSpecificExceptionBase):

    error = 1001
    default_message = "Permission Denied"


class RPCTagRelationCycleException(RPCPermanentError):

    error = CODES.TAG_RELATION_CYCLE
    default_message = CODES.getDesc(error)


class RPCStaffRequiredException(GaiaRPCSpecificExceptionBase):

    error = 1002
    default_message = "Staff Required"


class RPCNotFoundException(GaiaRPCSpecificExceptionBase):

    error = 1404
    default_message = "Not Found"


class RPCIntegrityError(GaiaRPCSpecificExceptionBase):
    error = 1601
    default_message = "Integrity Error"
