# -*- coding: utf-8 -*-
import six
from gm_tracer import middleware
from gm_tracer.context import current_tracer
from gm_tracer.contrib.django import unpatch
from gm_tracer.middleware import patch_packages


class TracerMiddleware(middleware.TracerMiddleware):
    def process_response(self, request, response):
        tracer = current_tracer()
        tracer.add_binary_annotation({
            'span.type': 'rpc',
            'http.code': six.text_type(response.status_code),
        })

        tracer.stop()
        if tracer.need_report():
            record = tracer.convert_to_pb_repr()
            self.logger(record)

        if tracer.debug:
            unpatch(**patch_packages)
        # purge_current_tracer()

        return response
