# -*- coding: utf-8 -*-
from typing import List, Dict

from rpc.context import get_rpc_remote_invoker


def get_doctor_id_by_user_id(user_id: int) -> int:
    result = get_rpc_remote_invoker()['gaia/get_doctor_id_by_user_id'](
        user_id=user_id,
    ).unwrap()
    return result.get('user_id')


def get_message_mark_user(user_id_list: List[int],
                          target_user_id_list: List[int]) \
        -> List[Dict]:
    return get_rpc_remote_invoker()['gaia/courier/mark_user'](
        user_id_list=user_id_list,
        target_user_id_list=target_user_id_list
    ).unwrap()