# -*- coding: utf-8 -*-
from gm_types.gaia import DOCTOR_TYPE

from adapter.old_system import bind_prefix
from api.models.message import Message, ConversationUserStatus
from common.types import SPECIAL_MSG_TYPE
from rpc.gaia_client import batch_get_doctor_info_by_user_ids


@bind_prefix('message/message/message_monitor')
def message_monitor(ctx, msg_ids):
    """ 异常私信监控对backend暴露接口 """
    ret = []
    user_id_list = []

    messages = Message.objects.filter(id__in=msg_ids)
    for message in messages:
        if message.type in SPECIAL_MSG_TYPE:
           content = Message.get_special_msg_content(message.type, message.body)
        else:
           content = Message.get_general_msg_content(message.type, message.content)

        cs = ConversationUserStatus.objects.filter(
            conversation_id=message.conversation_id
        ).exclude(user_id=message.user_id).first()
        if not cs:
            continue
        target_uid = cs.user_id

        user_id_list.append(target_uid)

        ret.append({
            "send_uid": message.user_id,
            "content": content,
            "send_time": message.send_time.strftime('%Y-%m-%d %H:%M:%S'),
            "conversation_id": message.conversation_id,
            'target_uid': target_uid,
        })

    user_id_doctor_info_dict = batch_get_doctor_info_by_user_ids(user_ids=user_id_list)
    for i in ret:
        doctor_info = user_id_doctor_info_dict.get(str(i.get('target_uid')))
        if not doctor_info:
            i.update(doctor_name='',
                     doctor_id='',
                     hospital_name='')
        else:
            doctor_name = doctor_info.get('meta', {}).get('name', '')
            if doctor_name:
                doctor_type = doctor_info.get('meta', {}).get('doctor_type')
                if doctor_type != DOCTOR_TYPE.OFFICER:
                    doctor_name = '{} 医生'.format(doctor_name)

            i.update(
                doctor_name=doctor_name,
                doctor_id=doctor_info.get('meta', {}).get('id', ''),
                hospital_name=doctor_info.get('meta', {}).get('hospital_name', '')
            )

    return ret