# -*- coding: utf-8 -*-
import functools
from typing import Union, Dict, List

import helios
from gm_types.error import ERROR

from adapter.log import logging_exception


def rpc_invoke_error_handle_decorator(invoke_func) -> (bool, Union[Dict, List]):
    @functools.wraps(invoke_func)
    def wrapper(*args, **kwargs):
        try:
            result = invoke_func(*args, **kwargs)
        except helios.rpc.internal.exceptions.RPCFaultException as e:
            # errors like lack of parameter, need logined .etc
            # url = e.parse_url(e.rpcd_server.v1_batch_url, e.request.method)
            # formated_message = e.kwargs.get('message', '')
            # url, e.request.params, e.request.session_key,
            logging_exception()
            return False, {'code':e.error, 'msg': e.message}
        except helios.rpc.internal.exceptions.RPCSystemException as e:
            # errors like attribute errror, unpack dict error .etc
            # url = e.parse_url(e.rpcd_server.v1_batch_url, e.request.method)
            # formated_message = e.kwargs.get('message', '')
            # print(formated_message) # Server Error: argument of type 'NoneType' is not iterable
            # print(url, e.request.params, e.request.session_key)
            logging_exception()
            return False, {'code': ERROR.UNIVERSAL, 'msg': ERROR.getDesc(ERROR.UNIVERSAL)}
        else:
            return True, result

    return wrapper