# -*- coding: utf-8 -*-
from typing import Dict

from django.contrib.auth.models import User
from django.db import models


class BaseUser(User):
    class Meta(User.Meta):
        db_table = 'auth_user'


class GaiaUser(User):
    # objects = models.Manager().db_manager(using='gaia')
    pass


def dict_to_user_obj(user_dict: Dict) -> BaseUser:
    if user_dict and user_dict.get('user_id'):
        user_dict['id'] = user_dict.pop('user_id')

    model_fields = {field.name for field in BaseUser._meta.fields}
    user = BaseUser()
    for k in set(user_dict.keys()) & model_fields:
        setattr(user, k, user_dict[k])
    return user