# coding=utf-8
from __future__ import unicode_literals, print_function, absolute_import


class Signal(object):

    def __init__(self, func=None):
        self.__handlers = []
        if func:
            self.connect(func)

    @classmethod
    def create(cls, func):
        return cls(func)

    def connect(self, func):
        self.__handlers.append(func)
        return func

    def __call__(self, *args, **kwargs):
        for func in self.__handlers:
            func(*args, **kwargs)


@Signal.create
def post_create_conversation(conversation, conversation_extra):
    pass


@Signal.create
def post_touch_conversation(user, conversation):
    pass

@Signal.create
def post_send_message(conversation):
    pass